package com.ejie.ab04b.service.platea;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.sc.xml.ConsultationContext;

/**
 * Clase que expone los metodos que atacan el FdCdP
 * 
 * @author GFI
 * 
 */
public interface FDCDPFacadeService {

	/**
	 * Servicio que recupera, dado un id de procedimiento, su informacion
	 * asociada en el FDCDP
	 * 
	 *  idProcedure
	 *            String
	 *  ConsultationContext ConsultationContext.
	 *
	 * @param idProcedure the id procedure
	 * @return the soft consultation context
	 * @throws AB04BException the AB 04 B exception
	 */
	public ConsultationContext getSoftConsultationContext(String idProcedure)
			throws AB04BException;

}
